<?php

namespace App\Http\Controllers\Customer;

use App\Http\Controllers\Controller;
use App\Models\Blacklists;
use App\Models\Campaigns;
use App\Models\ChatBox;
use App\Models\ChatBoxMessage;
use App\Models\ContactGroups;
use App\Models\ContactGroupsOptinKeywords;
use App\Models\ContactGroupsOptoutKeywords;
use App\Models\Contacts;
use App\Models\Keywords;
use App\Models\Notifications;
use App\Models\PhoneNumbers;
use App\Models\Reports;
use App\Models\SendingServer;
use App\Models\User;
use App\Repositories\Eloquent\EloquentCampaignRepository;
use Illuminate\Http\Request;
use Twilio\TwiML\MessagingResponse;

class DLRController extends Controller
{

    /**
     * update dlr
     *
     * @param      $message_id
     * @param      $status
     * @param  null  $sender_id
     * @param  null  $phone
     *
     * @return mixed
     */
    public static function updateDLR($message_id, $status, $sender_id = null, $phone = null)
    {

        $get_data = Reports::query()->when($message_id, function ($query) use ($message_id) {
            $query->whereLike(['status'], '%'.$message_id.'%');
        })->when($sender_id, function ($query) use ($sender_id) {
            $query->whereLike(['from'], '%'.$sender_id.'%');
        })->when($phone, function ($query) use ($phone) {
            $query->whereLike(['to'], '%'.$phone.'%');
        })->first();

        if ($get_data) {
            $get_data->status = $status;
            $get_data->save();
        }

        return $status;
    }


    /**
     *
     * @param  Request  $request
     */
    public function dlrTwilio(Request $request)
    {
        $message_id = $request->MessageSid;
        $status     = $request->MessageStatus;

        $this::updateDLR($message_id, $status);

    }

    /**
     * @param  Request  $request
     */
    public function dlrRouteMobile(Request $request)
    {
        $message_id = $request->sMessageId;
        $status     = $request->sStatus;
        $sender_id  = $request->sSender;
        $phone      = $request->sMobileNo;

        $this::updateDLR($message_id, $status, $sender_id, $phone);
    }


    public function dlrTextLocal(Request $request)
    {
        $message_id = $request->customID;
        $status     = $request->status;
        $phone      = $request->number;

        $this::updateDLR($message_id, $status, null, $phone);
    }


    public function dlrPlivo(Request $request)
    {
        $message_id = $request->MessageUUID;
        $status     = $request->Status;
        $phone      = $request->To;
        $sender_id  = $request->From;

        $this::updateDLR($message_id, $status, $phone, $sender_id);
    }

    public function dlrSMSGlobal(Request $request)
    {
        $message_id = $request->msgid;
        $status     = $request->dlrstatus;

        $this::updateDLR($message_id, $status);
    }


    public function dlrVonage(Request $request)
    {
        $message_id = $request->messageId;
        $status     = $request->status;
        $phone      = $request->msisdn;
        $sender_id  = $request->to;

        $this::updateDLR($message_id, $status, $phone, $sender_id);
    }

    public function dlrInfobip(Request $request)
    {
        $get_data = $request->getContent();

        $get_data = json_decode($get_data, true);
        if (isset($get_data) && is_array($get_data) && array_key_exists('results', $get_data)) {
            $message_id = $get_data['results']['0']['messageId'];

            foreach ($get_data['results'] as $msg) {

                if (isset($msg['status']['groupName'])) {
                    $this::updateDLR($message_id, $msg['status']['groupName']);
                }

            }
        }
    }


    public static function inboundDLR($to, $message, $sending_sever, $cost, $from = null)
    {
        if (config('app.env') == 'demo') {
            return response()->json([
                    'status'  => 'error',
                    'message' => 'Sorry!! This options is not available in demo mode',
            ]);
        }

        $to      = str_replace(['(', ')', '+', '-', ' '], '', trim($to));
        $from    = str_replace(['(', ')', '+', '-', ' '], '', trim($from));
        $user_id = 1;
        $price   = 1;
        $success = 'Success';
        $failed  = null;

        $sending_sever = SendingServer::where('settings', $sending_sever)->where('status', true)->first();
        $phone_number  = PhoneNumbers::where('number', $from)->where('status', 'assigned')->first();

        if ($phone_number) {
            $user_id = $phone_number->user_id;
            $user    = User::find($user_id);

            if (isset($user->customer)) {
                $unit_price = $user->customer->getOption('plain_sms');
                $price      = $cost * $unit_price;

                if ($price != 0) {
                    $user->customer->countUsage($price);
                }

                //checking chat box
                $chatBox = ChatBox::where('to', $to)->where('from', $from)->where('user_id', $user_id)->first();

                if ($chatBox) {
                    $chatBox->notification += 1;
                    $chatBox->save();
                } else {
                    $chatBox = ChatBox::create([
                            'user_id'      => $user_id,
                            'from'         => $from,
                            'to'           => $to,
                            'notification' => 1,
                    ]);
                }

                if ($chatBox) {

                    Notifications::create([
                            'user_id'           => $user_id,
                            'notification_for'  => 'customer',
                            'notification_type' => 'chatbox',
                            'message'           => 'New chat message arrive',
                    ]);

                    ChatBoxMessage::create([
                            'box_id'            => $chatBox->id,
                            'message'           => $message,
                            'sms_type'          => 'sms',
                            'send_by'           => 'to',
                            'sending_server_id' => $sending_sever->id,
                    ]);
                } else {
                    $failed .= 'Failed to create chat message ';
                }


                //check keywords
                $keyword = Keywords::where('user_id', $user_id)
                        ->select('*')
                        ->selectRaw('lower(keyword_name) as keyword,keyword_name')
                        ->where('keyword_name', strtolower($message))
                        ->where('status', 'assigned')->first();

                if ($keyword) {
                    //checking contact message
                    $contact_groups = ContactGroups::where('customer_id', $user_id)->select('id')->cursor()->pluck('id')->toArray();
                    $optInContacts  = ContactGroupsOptinKeywords::whereIn('contact_group', $contact_groups)->where('keyword', $message)->cursor();
                    $optOutContacts = ContactGroupsOptoutKeywords::whereIn('contact_group', $contact_groups)->where('keyword', $message)->cursor();

                    $blacklist = Blacklists::where('user_id', $user_id)->where('number', $to)->first();

                    if ($optInContacts->count()) {
                        foreach ($optInContacts as $contact) {
                            $exist = Contacts::where('group_id', $contact->contact_group)->where('phone', $to)->first();

                            if ($blacklist) {
                                $blacklist->delete();
                            }

                            if ( ! $exist) {
                                $data = Contacts::create([
                                        'customer_id' => $user_id,
                                        'group_id'    => $contact->contact_group,
                                        'phone'       => $to,
                                        'first_name'  => null,
                                        'last_name'   => null,
                                ]);

                                if ($data) {

                                    $sendMessage = new EloquentCampaignRepository($campaign = new Campaigns());

                                    if ($contact->ContactGroups->send_keyword_message) {
                                        if ($keyword->reply_text) {

                                            $sendMessage->quickSend($campaign, [
                                                    'sender_id' => $keyword->sender_id,
                                                    'sms_type'  => 'plain',
                                                    'message'   => $keyword->reply_text,
                                                    'recipient' => $to,
                                                    'user_id'   => $user_id,
                                            ]);

                                        }
                                    } else {
                                        if ($contact->ContactGroups->send_welcome_sms && $contact->ContactGroups->welcome_sms) {

                                            $sendMessage->quickSend($campaign, [
                                                    'sender_id' => $contact->ContactGroups->sender_id,
                                                    'sms_type'  => 'plain',
                                                    'message'   => $contact->ContactGroups->welcome_sms,
                                                    'recipient' => $to,
                                                    'user_id'   => $user_id,
                                            ]);

                                        }
                                    }

                                    $contact->ContactGroups->updateCache('SubscribersCount');
                                } else {
                                    $failed .= 'Failed to subscribe contact list';
                                }
                            } else {
                                $exist->update([
                                        'status' => 'subscribe',
                                ]);
                            }

                        }
                    } elseif ($optOutContacts->count()) {

                        foreach ($optOutContacts as $contact) {

                            if ( ! $blacklist) {
                                $exist = Contacts::where('group_id', $contact->contact_group)->where('phone', $to)->first();
                                if ($exist) {
                                    $data = $exist->update([
                                            'status' => 'unsubscribe',
                                    ]);

                                    if ($data) {
                                        Blacklists::create([
                                                'user_id' => $user_id,
                                                'number'  => $to,
                                                'reason'  => "Optout by User",
                                        ]);

                                        $sendMessage = new EloquentCampaignRepository($campaign = new Campaigns());

                                        if ($contact->ContactGroups->send_keyword_message) {
                                            if ($keyword->reply_text) {

                                                $sendMessage->quickSend($campaign, [
                                                        'sender_id' => $keyword->sender_id,
                                                        'sms_type'  => 'plain',
                                                        'message'   => $keyword->reply_text,
                                                        'recipient' => $to,
                                                        'user_id'   => $user_id,
                                                ]);

                                            }
                                        } else {
                                            if ($contact->ContactGroups->unsubscribe_notification && $contact->ContactGroups->unsubscribe_sms) {

                                                $sendMessage->quickSend($campaign, [
                                                        'sender_id' => $contact->ContactGroups->sender_id,
                                                        'sms_type'  => 'plain',
                                                        'message'   => $contact->ContactGroups->unsubscribe_sms,
                                                        'recipient' => $to,
                                                        'user_id'   => $user_id,
                                                ]);

                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        if ($keyword->reply_text) {
                            $sendMessage = new EloquentCampaignRepository($campaign = new Campaigns());
                            $sendMessage->quickSend($campaign, [
                                    'sender_id' => $keyword->sender_id,
                                    'sms_type'  => 'plain',
                                    'message'   => $keyword->reply_text,
                                    'recipient' => $to,
                                    'user_id'   => $user_id,
                            ]);

                        } else {
                            $failed .= 'Related keyword reply message not found.';
                        }
                    }
                }
            }
        }

        Reports::create([
                'user_id'           => $user_id,
                'from'              => $from,
                'to'                => $to,
                'message'           => $message,
                'sms_type'          => 'plain',
                'status'            => "Delivered",
                'send_by'           => "to",
                'cost'              => $cost,
                'sending_server_id' => $sending_sever->id,
        ]);


        if ($failed == null) {
            return $success;
        }

        return $failed;

    }


    public function inboundTwilio(Request $request)
    {

        $response = new MessagingResponse();

        $to      = $request->input('From');
        $from    = $request->input('To');
        $message = $request->input('Body');

        if ($to == null || $from == null || $message == null) {
            $response->message('From, To and Body value required');

            return $response;
        }

        $message_count = strlen(preg_replace('/\s+/', ' ', trim($message))) / 160;
        $cost          = ceil($message_count);

        $feedback = $this::inboundDLR($to, $message, 'Twilio', $cost, $from);

        dd($feedback);
    }

}
