<?php $__env->startSection('style'); ?>
    <?php echo Html::style("assets/libs/data-table/datatables.min.css"); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Coverage',Auth::guard('client')->user()->lan_id)); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">

                <div class="col-lg-12">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Coverage',Auth::guard('client')->user()->lan_id)); ?></h3>
                        </div>
                        <div class="panel-body p-none">
                            <table class="table data-table table-hover">
                                <thead>
                                <tr>
                                    <th style="width: 5%;"><?php echo e(language_data('SL',Auth::guard('client')->user()->lan_id)); ?>#</th>
                                    <th style="width: 15%;"><?php echo e(language_data('Country',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('ISO Code',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('Country Code',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 15%;"><?php echo e(language_data('Plain',Auth::guard('client')->user()->lan_id)); ?> <?php echo e(language_data('Price',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 15%;"><?php echo e(language_data('Voice',Auth::guard('client')->user()->lan_id)); ?> <?php echo e(language_data('Price',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 15%;"><?php echo e(language_data('MMS',Auth::guard('client')->user()->lan_id)); ?> <?php echo e(language_data('Price',Auth::guard('client')->user()->lan_id)); ?></th>
                                    <th style="width: 15%;"><?php echo e(language_data('Action',Auth::guard('client')->user()->lan_id)); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $country_codes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="SL"><?php echo e($loop->iteration); ?></td>
                                        <td data-label="Country"><p><?php echo e($cc->country_name); ?></p></td>
                                        <td data-label="ISO Code"><p><?php echo e($cc->iso_code); ?></p></td>
                                        <td data-label="Country Code"><p><?php echo e($cc->country_code); ?></p></td>
                                        <td data-label="Plain Price"><p><?php echo e($cc->plain_tariff); ?></p></td>
                                        <td data-label="Voice Price"><p><?php echo e($cc->voice_tariff); ?></p></td>
                                        <td data-label="MMS Price"><p><?php echo e($cc->mms_tariff); ?></p></td>
                                        <td data-label="Actions">
                                            <?php if(get_operator_count($cc->id)): ?>
                                                <a class="btn btn-complete btn-xs"
                                                   href="<?php echo e(url('user/sms/view-operator/'.$cc->id)); ?>"><i
                                                            class="fa fa-mobile"></i> <?php echo e(language_data('View Operator',Auth::guard('client')->user()->lan_id)); ?>

                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

    <?php echo Html::script("assets/libs/data-table/datatables.min.js"); ?>


    <script>
        $(document).ready(function(){
          $('.data-table').DataTable({
            language: {
              url: '<?php echo url("assets/libs/data-table/i18n/".get_language_code()->language.".lang"); ?>'
            },
            responsive: true
          });

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('client', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>