<?php $__env->startSection('style'); ?>
    <?php echo Html::style("assets/libs/bootstrap-datetimepicker/css/bootstrap-datetimepicker.min.css"); ?>


    <style>
        .progress-bar-indeterminate {
            background: url('../assets/img/progress-bar-complete.svg') no-repeat top left;
            width: 100%;
            height: 100%;
            background-size: cover;
        }
    </style>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Send Bulk SMS',Auth::guard('client')->user()->lan_id)); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">

            <div class="show_notification"></div>
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">
                <div class="col-lg-6">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Send Bulk SMS',Auth::guard('client')->user()->lan_id)); ?></h3>
                        </div>
                        <div class="panel-body">

                            <div class="form-group">
                                <div class="form-group">
                                    <a href="<?php echo e(url('user/sms/download-sample-sms-file')); ?>" class="btn btn-complete"><i
                                                class="fa fa-download"></i> <?php echo e(language_data('Download Sample File',Auth::guard('client')->user()->lan_id)); ?>

                                    </a>
                                </div>
                            </div>

                            <div id="send-sms-file-wrapper">


                                <form id="send-sms-file-form" class="" role="form" method="post"
                                      action="<?php echo e(url('user/sms/post-sms-from-file')); ?>" enctype="multipart/form-data">
                                    <?php echo e(csrf_field()); ?>


                                    <div class="form-group">
                                        <label><?php echo e(language_data('Import Numbers',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <div class="form-group input-group input-group-file">
                                        <span class="input-group-btn">
                                            <span class="btn btn-primary btn-file">
                                                <?php echo e(language_data('Browse',Auth::guard('client')->user()->lan_id)); ?> <input
                                                        type="file" class="form-control" name="import_numbers"
                                                        @change="handleImportNumbers">
                                            </span>
                                        </span>
                                            <input type="text" class="form-control" readonly="">
                                        </div>

                                        <div id='loadingmessage' style='display:none' class="form-group">
                                            <label><?php echo e(language_data('File Uploading.. Please wait',Auth::guard('client')->user()->lan_id)); ?></label>
                                            <div class="progress">
                                                <div class="progress-bar-indeterminate"></div>
                                            </div>
                                        </div>

                                        <div class="coder-checkbox">
                                            <input type="checkbox" name="header_exist" :checked="form.header_exist"
                                                   v-model="form.header_exist">
                                            <span class="co-check-ui"></span>
                                            <label><?php echo e(language_data('First Row As Header',Auth::guard('client')->user()->lan_id)); ?></label>
                                        </div>
                                    </div>


                                    <div class="form-group">
                                        <label><?php echo e(language_data('Country Code',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <select class="selectpicker form-control" name="country_code" data-live-search="true">
                                            <option value="0" <?php if(app_config('send_sms_country_code') == 0): ?> selected <?php endif; ?> ><?php echo e(language_data('Exist on phone number',Auth::guard('client')->user()->lan_id)); ?></option>
                                            <?php $__currentLoopData = $country_code; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($code->country_code); ?>" <?php if(app_config('send_sms_country_code') == $code->country_code): ?> selected <?php endif; ?> ><?php echo e($code->country_name); ?> (<?php echo e($code->country_code); ?>)</option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>


                                    <div class="form-group" v-show="number_columns.length > 0">
                                        <label><?php echo e(language_data('Phone Number',Auth::guard('client')->user()->lan_id)); ?> <?php echo e(language_data('Column',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <select class="selectpicker form-control" ref="number_column"
                                                name="number_column" data-live-search="true" v-model="number_column">
                                            <option v-for="column in number_columns" :value="column.key"
                                                    v-text="column.value"></option>
                                        </select>
                                    </div>


                                    <div class="form-group">
                                        <label><?php echo e(language_data('SMS Gateway',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <select class="selectpicker form-control" name="sms_gateway" data-live-search="true">
                                            <?php $__currentLoopData = $sms_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($gateway->id); ?>"><?php echo e($gateway->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <?php if(app_config('show_keyword_in_client') == 1): ?>
                                        <div class="form-group">
                                            <label><?php echo e(language_data('Campaign Keyword',Auth::guard('client')->user()->lan_id)); ?></label>
                                            <select class="selectpicker form-control" name="keyword[]" data-live-search="true" multiple>
                                                <?php $__currentLoopData = $keyword; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($kw->keyword_name); ?>"><?php echo e($kw->title); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    <?php endif; ?>

                                    <?php if(app_config('sender_id_verification') == 1): ?>
                                        <?php if($sender_ids): ?>
                                            <div class="form-group">
                                                <label><?php echo e(language_data('Sender ID',Auth::guard('client')->user()->lan_id)); ?></label>
                                                <select class="selectpicker form-control sender_id" name="sender_id"
                                                        data-live-search="true">
                                                    <?php $__currentLoopData = $sender_ids; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $si): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($si); ?>"><?php echo e($si); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        <?php else: ?>
                                            <div class="form-group">
                                                <label><?php echo e(language_data('Sender ID',Auth::guard('client')->user()->lan_id)); ?></label>
                                                <p><a href="<?php echo e(url('user/sms/sender-id-management')); ?>"
                                                      class="text-uppercase"><?php echo e(language_data('Request New Sender ID',Auth::guard('client')->user()->lan_id)); ?></a>
                                                </p>
                                            </div>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="form-group">
                                            <label><?php echo e(language_data('Sender ID',Auth::guard('client')->user()->lan_id)); ?></label>
                                            <input type="text" class="form-control sender_id" name="sender_id">
                                        </div>
                                    <?php endif; ?>


                                    <div class="form-group">
                                        <label><?php echo e(language_data('Remove Duplicate',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <select class="selectpicker form-control" name="remove_duplicate">
                                            <option value="yes"><?php echo e(language_data('Yes',Auth::guard('client')->user()->lan_id)); ?></option>
                                            <option value="no"><?php echo e(language_data('No',Auth::guard('client')->user()->lan_id)); ?></option>
                                        </select>
                                    </div>


                                    <div class="form-group">
                                        <label><?php echo e(language_data('Message Type',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <select class="selectpicker form-control message_type" name="message_type">
                                            <option value="plain"><?php echo e(language_data('Plain',Auth::guard('client')->user()->lan_id)); ?></option>
                                            <option value="unicode"><?php echo e(language_data('Unicode',Auth::guard('client')->user()->lan_id)); ?></option>
                                            <option value="arabic"><?php echo e(language_data('Arabic',Auth::guard('client')->user()->lan_id)); ?></option>
                                            <option value="voice"><?php echo e(language_data('Voice',Auth::guard('client')->user()->lan_id)); ?></option>
                                            <option value="mms"><?php echo e(language_data('MMS',Auth::guard('client')->user()->lan_id)); ?></option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label><?php echo e(language_data('Message',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <textarea class="form-control" name="message" rows="5" id="message"
                                                  ref="message"></textarea>
                                        <span class="help text-uppercase"
                                              id="remaining">160 <?php echo e(language_data('characters remaining',Auth::guard('client')->user()->lan_id)); ?></span>
                                        <span class="help text-success"
                                              id="messages">1 <?php echo e(language_data('message',Auth::guard('client')->user()->lan_id)); ?>

                                            (s)</span>
                                    </div>


                                    <div class="form-group">
                                        <div class="coder-checkbox">
                                            <input type="checkbox" value="yes" name="unsubscribe_sms" class="unsubscribe_sms">
                                            <span class="co-check-ui"></span>
                                            <label><?php echo e(language_data('Generate unsubscribe message',Auth::guard('client')->user()->lan_id)); ?></label>
                                        </div>
                                    </div>

                                    <div class="form-group send-mms">
                                        <label><?php echo e(language_data('Select File',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <div class="form-group input-group input-group-file">
                                        <span class="input-group-btn">
                                            <span class="btn btn-primary btn-file">
                                                <?php echo e(language_data('Browse',Auth::guard('client')->user()->lan_id)); ?> <input
                                                        type="file" class="form-control" name="image"
                                                        accept="audio/*,video/*,image/*">
                                            </span>
                                        </span>
                                            <input type="text" class="form-control" readonly="">
                                        </div>
                                    </div>


                                    <div class="row">

                                        <div class="col-sm-6" v-show="number_columns.length > 0">
                                            <div class="form-group">
                                                <label><?php echo e(language_data('Select Merge Field',Auth::guard('client')->user()->lan_id)); ?></label>
                                                <select class="selectpicker form-control" ref="merge_field"
                                                        data-live-search="true" v-model="number_column">
                                                    <option v-for="column in number_columns" :value="column.key"
                                                            v-text="column.value"></option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-sm-6">
                                            <div class="form-group">
                                                <label><?php echo e(language_data('SMS Templates',Auth::guard('client')->user()->lan_id)); ?></label>
                                                <select class="selectpicker form-control" name="sms_template"
                                                        data-live-search="true" id="sms_template">
                                                    <option><?php echo e(language_data('Select Template',Auth::guard('client')->user()->lan_id)); ?></option>
                                                    <?php $__currentLoopData = $sms_templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $st): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($st->id); ?>"><?php echo e($st->template_name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                    </div>


                                    <div class="form-group">
                                        <div class="coder-checkbox">
                                            <input type="checkbox" name="send_later" <?php if($schedule_sms): ?> checked
                                                   <?php endif; ?> class="send_later" value="on">
                                            <span class="co-check-ui"></span>
                                            <label><?php echo e(language_data('Send Later',Auth::guard('client')->user()->lan_id)); ?></label>
                                        </div>
                                    </div>


                                    <div class="schedule_time">


                                        <div class="form-group">
                                            <label><?php echo e(language_data('Schedule Time Type',Auth::guard('client')->user()->lan_id)); ?></label>
                                            <select class="selectpicker form-control schedule_time_type"
                                                    ref="schedule_time_type" name="schedule_time_type">
                                                <option value="from_date"><?php echo e(language_data('Schedule Time Using Date',Auth::guard('client')->user()->lan_id)); ?></option>
                                                <option value="from_file"><?php echo e(language_data('Schedule Time Using File',Auth::guard('client')->user()->lan_id)); ?></option>
                                            </select>
                                        </div>

                                        <div class="form-group from_date">
                                            <label><?php echo e(language_data('Schedule Time',Auth::guard('client')->user()->lan_id)); ?></label>
                                            <input type="text" class="form-control dateTimePicker" name="schedule_time">
                                            <span class="help text-danger text-uppercase"><?php echo e(language_data('Schedule Time must contain this format',Auth::guard('client')->user()->lan_id)); ?>

                                                ( dd/mm/yyyy h:m AM ) Ex. <?php echo e(date('m/d/Y h:i A')); ?></span>
                                        </div>

                                        <div class="form-group from_file"
                                             v-show="number_columns.length > 0 && schedule_time_type == 'from_file'">
                                            <label><?php echo e(language_data('Schedule Time',Auth::guard('client')->user()->lan_id)); ?> <?php echo e(language_data('Column',Auth::guard('client')->user()->lan_id)); ?></label>
                                            <select class="selectpicker form-control" ref="schedule_time_column"
                                                    name="schedule_time_column" data-live-search="true"
                                                    v-model="schedule_time_column">
                                                <option v-for="column in number_columns" :value="column.key"
                                                        v-text="column.value"></option>
                                            </select>
                                            <span class="help text-danger text-uppercase"><?php echo e(language_data('Schedule Time must contain this format',Auth::guard('client')->user()->lan_id)); ?>

                                                ( dd/mm/yyyy h:m AM ) Ex. <?php echo e(date('m/d/Y h:i A')); ?></span>
                                        </div>

                                    </div>

                                    <div id='uploadContact' style='display:none' class="form-group">
                                        <label><?php echo e(language_data('Message adding in Queue.. Please wait',Auth::guard('client')->user()->lan_id)); ?></label>
                                        <div class="progress">
                                            <div class="progress-bar-indeterminate"></div>
                                        </div>
                                    </div>


                                    <input type="hidden" value="<?php echo e($schedule_sms); ?>" id="schedule_sms_status"
                                           name="schedule_sms_status">


                                    <span class="text-uppercase text-complete help"><?php echo e(language_data('After click on Send button, do not refresh your browser',Auth::guard('client')->user()->lan_id)); ?></span>

                                    <button type="submit" id="submitContact" class="btn btn-success btn-sm pull-right">
                                        <i class="fa fa-send"></i> <?php echo e(language_data('Send',Auth::guard('client')->user()->lan_id)); ?>

                                    </button>

                                </form>
                            </div>

                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/libs/moment/moment.min.js"); ?>

    <?php echo Html::script("assets/libs/bootstrap-datetimepicker/js/bootstrap-datetimepicker.min.js"); ?>

    <?php echo Html::script("assets/js/vue.js"); ?>

    <?php echo Html::script("assets/js/file_upload.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>


    <script>
        $(document).ready(function () {


            $('#submitContact').click(function () {
                $(this).hide();
                $('#uploadContact').show();
            });


            var $get_msg = $("#message"),
                $remaining = $('#remaining'),
                $messages = $remaining.next(),
                message_type = 'plain',
                maxCharInitial = 160,
                maxChar = 157,
                messages = 1,
                schedule_sms_status = $('#schedule_sms_status').val(),
                _url = $("#_url").val(),
                unsubscribe_message = $('#_unsubscribe_message').val();
            if (schedule_sms_status) {
                $('.schedule_time').show();
            } else {
                $('.schedule_time').hide();
            }

            $('.send_later').change(function () {
                $('.schedule_time').fadeToggle();
            });

            $('.schedule_time_type').on('change', function () {
                if (this.value == 'from_date') {
                    $('.from_file').hide();
                    $('.from_date').show();
                } else {
                    $('.from_date').hide();
                    $('.from_file').show();
                }
            });

            function get_character() {
                var totalChar = $get_msg[0].value.length;
                var remainingChar = maxCharInitial;

                if (totalChar <= maxCharInitial) {
                    remainingChar = maxCharInitial - totalChar;
                    messages = 1;
                } else {
                    totalChar = totalChar - maxCharInitial;
                    messages = Math.ceil(totalChar / maxChar);
                    remainingChar = messages * maxChar - totalChar;
                    messages = messages + 1;
                }

                $remaining.text(remainingChar + " <?php echo language_data('characters remaining',Auth::guard('client')->user()->lan_id); ?>");
                $messages.text(messages + " <?php echo language_data('message',Auth::guard('client')->user()->lan_id); ?>" + '(s)');
            }

            $('.send-mms').hide();
            $('.message_type').on('change', function () {
                message_type = $(this).val();
                $get_msg.css('direction', 'ltr');

                if (message_type == 'unicode') {
                    maxCharInitial = 70;
                    maxChar = 67;
                    messages = 1;
                    $('.send-mms').hide();
                    get_character()
                }


                if (message_type == 'arabic') {
                    maxCharInitial = 70;
                    maxChar = 67;
                    messages = 1;
                    $('.send-mms').hide();
                    $get_msg.css('direction', 'rtl');
                    get_character()
                }

                if (message_type == 'plain' || message_type == 'voice') {
                    maxCharInitial = 160;
                    maxChar = 157;
                    messages = 1;
                    $('.send-mms').hide();
                    get_character()
                }

                if (message_type == 'mms') {
                    $('.send-mms').show();
                }

            });

            $("#sms_template").change(function () {
                var id = $(this).val();
                var dataString = 'st_id=' + id;
                $.ajax
                ({
                    type: "POST",
                    url: _url + '/user/sms/get-template-info',
                    data: dataString,
                    cache: false,
                    success: function (data) {
                        $("#sender_id").val(data.from);

                        var totalChar = $get_msg.val(data.message).val().length;
                        var remainingChar = maxCharInitial;

                        if (totalChar <= maxCharInitial) {
                            remainingChar = maxCharInitial - totalChar;
                            messages = 1;
                        } else {
                            totalChar = totalChar - maxCharInitial;
                            messages = Math.ceil(totalChar / maxChar);
                            remainingChar = messages * maxChar - totalChar;
                            messages = messages + 1;
                        }

                        $remaining.text(remainingChar + " <?php echo language_data('characters remaining',Auth::guard('client')->user()->lan_id); ?>");
                        $messages.text(messages + " <?php echo language_data('message',Auth::guard('client')->user()->lan_id); ?>" + '(s)');
                    }
                });
            });

            function isDoubleByte(str) {
                for (var i = 0, n = str.length; i < n; i++) {
                    if (str.charCodeAt(i) > 255) {
                        return true;
                    }
                }
                return false;
            }

            function get_message_type() {
                if ($get_msg[0].value !== null) {
                    if (isDoubleByte($get_msg[0].value) === true) {
                        $('.message_type').val('unicode').change();
                    } else {
                        $('.message_type').val('plain').change();
                    }
                }
            }

            $(".unsubscribe_sms").change(function () {
                if (this.checked == true) {
                    $('#message').val(function (_, v) {
                        return v + unsubscribe_message;
                    });
                } else {
                    $('#message').val(function (_, v) {
                        return v.replace(unsubscribe_message, '');
                    });
                }
                get_character();
            });

            $get_msg.keyup(get_message_type);
            $get_msg.keyup(get_character);

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('client', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>