<style>
    .progress-bar-indeterminate {
        background: url('../assets/img/progress-bar-complete.svg') no-repeat top left;
        width: 100%;
        height: 100%;
        background-size: cover;
    }
</style>

<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Export and Import Clients')); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <div class="show_notification"></div>
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">

                <div class="col-lg-4">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Export Clients')); ?></h3>
                        </div>
                        <div class="panel-body">
                            <ul class="info-list">
                                <li>
                                    <span class="info-list-title"><?php echo e(language_data('Export Clients')); ?></span><span class="info-list-des"><a href="<?php echo e(url('clients/export-clients')); ?>" class="btn btn-success btn-xs"><?php echo e(language_data('Export Clients as CSV')); ?></a></span>
                                </li>
                                <li>
                                    <span class="info-list-title"><?php echo e(language_data('Sample File')); ?></span><span class="info-list-des"><a href="<?php echo e(url('clients/download-sample-csv')); ?>" class="btn btn-complete btn-xs"><?php echo e(language_data('Download Sample File')); ?></a> </span>
                                </li>

                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Import Clients')); ?></h3>
                        </div>
                        <div class="panel-body">
                            <div id="import-clients">
                                <form id="import-client-from-file" role="form" method="post" action="<?php echo e(url('clients/post-new-client-csv')); ?>" enctype="multipart/form-data">
                                    <?php echo e(csrf_field()); ?>

                                    <div class="form-group">
                                        <label><?php echo e(language_data('Client Group')); ?></label>
                                        <select class="selectpicker form-control" name="client_group"  data-live-search="true">
                                            <option value="0"><?php echo e(language_data('None')); ?></option>
                                            <?php $__currentLoopData = $client_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cg->id); ?>"><?php echo e($cg->group_name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label><?php echo e(language_data('SMS Gateway')); ?></label>
                                        <select class="selectpicker form-control" name="sms_gateway[]"  data-live-search="true" multiple>
                                            <?php $__currentLoopData = $sms_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($sg->id); ?>"><?php echo e($sg->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>


                                    <div class="form-group">
                                        <label><?php echo e(language_data('Reseller Panel')); ?></label>
                                        <select class="selectpicker form-control" name="reseller_panel">
                                            <option value="Yes"><?php echo e(language_data('Yes')); ?></option>
                                            <option value="No"><?php echo e(language_data('No')); ?></option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label><?php echo e(language_data('Api Access')); ?></label>
                                        <select class="selectpicker form-control" name="api_access">
                                            <option value="Yes"><?php echo e(language_data('Yes')); ?></option>
                                            <option value="No"><?php echo e(language_data('No')); ?></option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <label><?php echo e(language_data('Import Clients')); ?></label>
                                        <div class="form-group input-group input-group-file">
                                            <span class="input-group-btn">
                                                <span class="btn btn-primary btn-file">
                                                <?php echo e(language_data('Browse')); ?> <input type="file" class="form-control" name="import_client" @change="handleImportClients">
                                                </span>
                                            </span>
                                            <input type="text" class="form-control" readonly="">
                                        </div>
                                    </div>

                                    <div id='loadingmessage' style='display:none' class="form-group">
                                        <label><?php echo e(language_data('File Uploading.. Please wait')); ?></label>
                                        <div class="progress">
                                            <div class="progress-bar-indeterminate"></div>
                                        </div>
                                    </div>

                                    <div class="coder-checkbox">
                                        <input type="checkbox" name="header_exist" :checked="form.header_exist" v-model="form.header_exist">
                                        <span class="co-check-ui"></span>
                                        <label><?php echo e(language_data('First Row As Header')); ?></label>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('First name')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <span class="help">Required</span>
                                        <select class="selectpicker form-control" ref="first_name_column" name="first_name_column" data-live-search="true" v-model="first_name_column">
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Last name')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <select class="selectpicker form-control" ref="last_name_column" name="last_name_column" data-live-search="true">
                                            <option :value="0"></option>
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Company')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <select class="selectpicker form-control" ref="company_column" name="company_column" data-live-search="true">
                                            <option :value="0"></option>
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Website')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <select class="selectpicker form-control" ref="website_column" name="website_column" data-live-search="true">
                                            <option :value="0"></option>
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Email')); ?> <?php echo e(language_data('Address')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <span class="help">Required</span>
                                        <select class="selectpicker form-control" ref="email_address_column" name="email_address_column" data-live-search="true" v-model="email_address_column">
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('User name')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <span class="help">Required</span>
                                        <select class="selectpicker form-control" ref="user_name_column" name="user_name_column" data-live-search="true" v-model="user_name_column">
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Password')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <span class="help">Required</span>
                                        <select class="selectpicker form-control" ref="password_column" name="password_column" data-live-search="true" v-model="password_column">
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Phone Number')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <span class="help">Required</span>
                                        <select class="selectpicker form-control" ref="number_column" name="number_column" data-live-search="true" v-model="number_column">
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Address')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <select class="selectpicker form-control" ref="address_column" name="address_column" data-live-search="true">
                                            <option :value="0"></option>
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('More Address')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <select class="selectpicker form-control" ref="more_address_column" name="more_address_column" data-live-search="true">
                                            <option :value="0"></option>
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('State')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <select class="selectpicker form-control" ref="state_column" name="state_column" data-live-search="true">
                                            <option :value="0"></option>
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('City')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <select class="selectpicker form-control" ref="city_column" name="city_column" data-live-search="true">
                                            <option :value="0"></option>
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Postcode')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <select class="selectpicker form-control" ref="postcode_column" name="postcode_column" data-live-search="true">
                                            <option :value="0"></option>
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('Country')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <span class="help">Required</span>
                                        <select class="selectpicker form-control" ref="country_column" name="country_column" data-live-search="true" v-model="country_column">
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div class="form-group" v-show="client_columns.length > 0">
                                        <label><?php echo e(language_data('SMS Limit')); ?> <?php echo e(language_data('Column')); ?></label>
                                        <span class="help">Required</span>
                                        <select class="selectpicker form-control" ref="sms_limit_column" name="sms_limit_column" data-live-search="true" v-model="sms_limit_column">
                                            <option v-for="column in client_columns" :value="column.key" v-text="column.value"></option>
                                        </select>
                                    </div>

                                    <div id='uploadContact' style='display:none' class="form-group">
                                        <label><?php echo e(language_data('Contact importing.. Please wait')); ?></label>
                                        <div class="progress">
                                            <div class="progress-bar-indeterminate"></div>
                                        </div>
                                    </div>

                                    <br>
                                    <p class="text-uppercase text-complete help"><?php echo e(language_data('It will take few minutes. Please do not reload the page')); ?></p>
                                    <button type="submit" class="btn btn-success btn-sm pull-right"><i class="fa fa-download"></i> <?php echo e(language_data('Import')); ?> </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

    <?php echo Html::script("assets/js/vue.js"); ?>

    <?php echo Html::script("assets/js/import_client.js"); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>