<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('View Invoice',Auth::guard('client')->user()->lan_id)); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

            <div class="panel">
                <div class="panel-body p-none">
                    <div class="p-20">
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="col-lg-6 col-md-3 col-sm-3 col-xs-12">
                                    <div class="m-b-5">
                                        <img src="<?php echo asset(app_config('AppLogo')); ?>" alt="Logo">
                                    </div>
                                    <address>
                                        <?php echo app_config('Address'); ?>

                                    </address>

                                    <div class="m-t-20">
                                        <h3 class="panel-title"><?php echo e(language_data('Invoice To',Auth::guard('client')->user()->lan_id)); ?>: </h3>
                                        <h3 class="invoice-to-client-name"><?php echo e($inv->client_name); ?></h3>
                                    </div>

                                    <address>
                                        <?php echo e($client->address1); ?> <br>
                                        <?php echo e($client->address2); ?> <br>
                                        <?php echo e($client->state); ?>, <?php echo e($client->city); ?> - <?php echo e($client->postcode); ?>,  <?php echo e($client->country); ?>

                                        <br><br>
                                        <?php echo e(language_data('Phone',Auth::guard('client')->user()->lan_id)); ?>: <?php echo e($client->phone); ?>

                                        <br>
                                        <?php echo e(language_data('Email',Auth::guard('client')->user()->lan_id)); ?>: <?php echo e($client->email); ?>

                                    </address>

                                </div>

                                <div class="col-lg-6 col-md-3 col-sm-3 col-xs-12">


                                    <div class="btn-group pull-right" aria-label="...">

                                        <?php if($inv->status=='Unpaid' || $inv->status=='Partially Paid'): ?>
                                            <a href="#" data-toggle="modal" data-target="#pay-invoice" class="btn btn-success  btn-sm pay-invoice"><i class="fa fa-check"></i> <?php echo e(language_data('Pay',Auth::guard('client')->user()->lan_id)); ?></a>
                                        <?php endif; ?>

                                        <a href="<?php echo e(url('user/invoices/client-iview/'.$inv->id)); ?>" target="_blank" class="btn btn-danger  btn-sm"><i class="fa fa-paper-plane-o"></i> <?php echo e(language_data('Preview',Auth::guard('client')->user()->lan_id)); ?></a>

                                        <a href="<?php echo e(url('user/invoices/download-pdf/'.$inv->id)); ?>" class="btn btn-pdf  btn-sm download-pdf"><i class="fa fa-file-pdf-o"></i> <?php echo e(language_data('PDF',Auth::guard('client')->user()->lan_id)); ?></a>
                                        <a href="<?php echo e(url('user/invoices/iprint/'.$inv->id)); ?>" target="_blank" class="btn btn-primary  btn-sm"><i class="fa fa-print"></i> <?php echo e(language_data('Print',Auth::guard('client')->user()->lan_id)); ?></a>
                                        <br>
                                        <br>

                                        <div class="modal fade" id="pay-invoice" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                                        <h4 class="modal-title" id="myModalLabel"><?php echo e(language_data('Pay Invoice',Auth::guard('client')->user()->lan_id)); ?></h4>
                                                    </div>
                                                    <div class="modal-body">

                                                        <form class="form-some-up" role="form" action="<?php echo e(url('user/invoices/pay-invoice')); ?>" method="post">

                                                            <div class="form-group">
                                                                <label><?php echo e(language_data('Select Payment Method',Auth::guard('client')->user()->lan_id)); ?></label>
                                                                <select class="selectpicker form-control" name="gateway">
                                                                    <?php $__currentLoopData = $payment_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($pg->id); ?>"><?php echo e($pg->name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>

                                                            <div class="text-right">
                                                                <input type="hidden" value="<?php echo e($inv->id); ?>" name="cmd">
                                                                <button type="button" class="btn btn-warning btn-sm" data-dismiss="modal"><?php echo e(language_data('Close',Auth::guard('client')->user()->lan_id)); ?></button>
                                                                <button type="submit" class="btn btn-success btn-sm"><?php echo e(language_data('Pay',Auth::guard('client')->user()->lan_id)); ?></button>
                                                            </div>
                                                        </form>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                            <div class="m-t-20">
                                                <div class="bill-data">
                                                    <p class="m-b-5">
                                                        <span class="bill-data-title"><?php echo e(language_data('Invoice No',Auth::guard('client')->user()->lan_id)); ?>:</span>
                                                        <span class="bill-data-value">#<?php echo e($inv->id); ?></span>
                                                    </p>
                                                    <p class="m-b-5">
                                                        <span class="bill-data-title"><?php echo e(language_data('Invoice Status',Auth::guard('client')->user()->lan_id)); ?>:</span>
                                                        <?php if($inv->status=='Unpaid'): ?>
                                                            <span class="bill-data-value"><span class="bill-data-status label-warning"><?php echo e(language_data('Unpaid',Auth::guard('client')->user()->lan_id)); ?></span></span>
                                                        <?php elseif($inv->status=='Paid'): ?>
                                                            <span class="bill-data-value"><span class="bill-data-status label-success"><?php echo e(language_data('Paid',Auth::guard('client')->user()->lan_id)); ?></span></span>
                                                        <?php elseif($inv->status=='Partially Paid'): ?>
                                                            <span class="bill-data-value"><span class="bill-data-status label-info"><?php echo e(language_data('Partially Paid',Auth::guard('client')->user()->lan_id)); ?></span></span>
                                                        <?php else: ?>
                                                            <span class="bill-data-value"><span class="bill-data-status label-danger"><?php echo e(language_data('Cancelled',Auth::guard('client')->user()->lan_id)); ?></span></span>
                                                        <?php endif; ?>
                                                    </p>
                                                    <p class="m-b-5">
                                                        <span class="bill-data-title"><?php echo e(language_data('Invoice Date',Auth::guard('client')->user()->lan_id)); ?>:</span>
                                                        <span class="bill-data-value"><?php echo e(get_date_format($inv->created)); ?></span>
                                                    </p>
                                                    <p class="m-b-5">
                                                        <span class="bill-data-title"><?php echo e(language_data('Due Date',Auth::guard('client')->user()->lan_id)); ?>:</span>
                                                        <span class="bill-data-value"><?php echo e(get_date_format($inv->duedate)); ?></span>
                                                    </p>
                                                    <?php if($inv->status=='Paid'): ?>
                                                        <p class="m-b-5">
                                                            <span class="bill-data-title"><?php echo e(language_data('Paid Date',Auth::guard('client')->user()->lan_id)); ?>:</span>
                                                            <span class="bill-data-value"><?php echo e(get_date_format($inv->datepaid)); ?></span>
                                                        </p>
                                                    <?php endif; ?>

                                                </div>
                                            </div>

                                    </div>


                                </div>

                            </div>

                            <div class="col-lg-12 col-md-3 col-sm-3 col-xs-12">
                                <table class="table table-hover table-ultra-responsive">
                                    <thead>
                                    <tr class="h5 text-dark">
                                        <th style="width: 5%;">#</th>
                                        <th style="width: 65%;"><?php echo e(language_data('Item',Auth::guard('client')->user()->lan_id)); ?></th>
                                        <th style="width: 10%;"><?php echo e(language_data('Price',Auth::guard('client')->user()->lan_id)); ?></th>
                                        <th style="width: 10%;"><?php echo e(language_data('Quantity',Auth::guard('client')->user()->lan_id)); ?></th>
                                        <th style="width: 10%;"><?php echo e(language_data('Total',Auth::guard('client')->user()->lan_id)); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $inv_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $it): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td data-label="<?php echo e(language_data('Item',Auth::guard('client')->user()->lan_id)); ?>"><?php echo e($loop->iteration); ?></td>
                                            <td data-label="<?php echo e(language_data('Price',Auth::guard('client')->user()->lan_id)); ?>"><?php echo e($it->item); ?></td>
                                            <td data-label="<?php echo e(language_data('Quantity',Auth::guard('client')->user()->lan_id)); ?>"><?php echo e(app_config('CurrencyCode')); ?> <?php echo e($it->price); ?></td>
                                            <td data-label="<?php echo e(language_data('Total',Auth::guard('client')->user()->lan_id)); ?>"><?php echo e($it->qty); ?></td>
                                            <td data-label="<?php echo e(language_data('Subtotal',Auth::guard('client')->user()->lan_id)); ?>"><?php echo e(app_config('CurrencyCode')); ?> <?php echo e($it->subtotal); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>

                            <div class="col-lg-12 col-md-3 col-sm-3 col-xs-12">
                                <div class="invoice-summary">
                                    <div class="row">
                                        <div class="col-lg-2 col-md-3 col-sm-3 col-xs-12">
                                            <div class="inv-block">
                                                <h3 class="count-title"><?php echo e(language_data('Subtotal',Auth::guard('client')->user()->lan_id)); ?></h3>
                                                <p><?php echo e(app_config('CurrencyCode')); ?> <?php echo e($inv->subtotal); ?></p>
                                            </div>
                                        </div>
                                        <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                            <div class="inv-block">
                                                <h3 class="count-title"><?php echo e(language_data('Tax',Auth::guard('client')->user()->lan_id)); ?></h3>
                                                <p><?php echo e(app_config('CurrencyCode')); ?> <?php echo e($tax_sum); ?></p>
                                            </div>
                                        </div>
                                        <div class="col-lg-2 col-md-2 col-sm-2 col-xs-12">
                                            <div class="inv-block">
                                                <h3 class="count-title"><?php echo e(language_data('Discount',Auth::guard('client')->user()->lan_id)); ?></h3>
                                                <p><?php echo e(app_config('CurrencyCode')); ?> <?php echo e($dis_sum); ?></p>
                                            </div>
                                        </div>
                                        <div class="col-lg-4 col-md-4 col-sm-4 col-xs-12 col-lg-offset-2 col-md-offset-1 col-sm-offset-1 text-right">
                                            <div class="inv-block last">
                                                <h3 class="count-title"><?php echo e(language_data('Grand Total',Auth::guard('client')->user()->lan_id)); ?></h3>
                                                <p><?php echo e(app_config('CurrencyCode')); ?> <?php echo e($inv->total); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <?php if($inv->note!=''): ?>
                                    <div class="well m-t-5 col-lg-12 col-md-3 col-sm-3 col-xs-12"><b><?php echo e(language_data('Invoice Note',Auth::guard('client')->user()->lan_id)); ?>: </b><?php echo e($inv->note); ?></div>
                                <?php endif; ?>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('client', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>