<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Messaging\V1\Service;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Serialize;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class UsAppToPersonList extends ListResource {
    /**
     * Construct the UsAppToPersonList
     *
     * @param Version $version Version that contains the resource
     * @param string $messagingServiceSid The SID of the Messaging Service the
     *                                    resource is associated with
     */
    public function __construct(Version $version, string $messagingServiceSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['messagingServiceSid' => $messagingServiceSid, ];

        $this->uri = '/Services/' . \rawurlencode($messagingServiceSid) . '/Compliance/Usa2p';
    }

    /**
     * Create the UsAppToPersonInstance
     *
     * @param string $brandRegistrationSid A2P Brand Registration SID
     * @param string $description A short description of what this SMS campaign does
     * @param string[] $messageSamples Message samples
     * @param string $usAppToPersonUsecase A2P Campaign Use Case.
     * @param bool $hasEmbeddedLinks Indicates that this SMS campaign will send
     *                               messages that contain links
     * @param bool $hasEmbeddedPhone Indicates that this SMS campaign will send
     *                               messages that contain phone numbers
     * @return UsAppToPersonInstance Created UsAppToPersonInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $brandRegistrationSid, string $description, array $messageSamples, string $usAppToPersonUsecase, bool $hasEmbeddedLinks, bool $hasEmbeddedPhone): UsAppToPersonInstance {
        $data = Values::of([
            'BrandRegistrationSid' => $brandRegistrationSid,
            'Description' => $description,
            'MessageSamples' => Serialize::map($messageSamples, function($e) { return $e; }),
            'UsAppToPersonUsecase' => $usAppToPersonUsecase,
            'HasEmbeddedLinks' => Serialize::booleanToString($hasEmbeddedLinks),
            'HasEmbeddedPhone' => Serialize::booleanToString($hasEmbeddedPhone),
        ]);

        $payload = $this->version->create('POST', $this->uri, [], $data);

        return new UsAppToPersonInstance($this->version, $payload, $this->solution['messagingServiceSid']);
    }

    /**
     * Delete the UsAppToPersonInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Fetch the UsAppToPersonInstance
     *
     * @return UsAppToPersonInstance Fetched UsAppToPersonInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): UsAppToPersonInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new UsAppToPersonInstance($this->version, $payload, $this->solution['messagingServiceSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Messaging.V1.UsAppToPersonList]';
    }
}