<?php $__env->startSection('style'); ?>
    <?php echo Html::style("assets/libs/data-table/datatables.min.css"); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('View Operator')); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">

                <div class="col-lg-12">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('View Operator')); ?></h3>
                        </div>
                        <div class="panel-body p-none">
                            <table class="table data-table table-hover">
                                <thead>
                                <tr>
                                    <th style="width: 5%;"><?php echo e(language_data('SL')); ?></th>
                                    <th style="width: 20%;"><?php echo e(language_data('Operator name')); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('Operator code')); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('Plain')); ?> <?php echo e(language_data('Price')); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('Voice')); ?> <?php echo e(language_data('Price')); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('MMS')); ?> <?php echo e(language_data('Price')); ?></th>
                                    <th style="width: 10%;"><?php echo e(language_data('Status')); ?></th>
                                    <th style="width: 25%;"><?php echo e(language_data('Action')); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $operators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td data-label="SL"><?php echo e($loop->iteration); ?></td>
                                        <td data-label="Operator Name"><p><?php echo e($op->operator_name); ?></p></td>
                                        <td data-label="Operator Code"><p><?php echo e($op->operator_code); ?></p></td>
                                        <td data-label="Plain Price"><p><?php echo e($op->plain_price); ?></p></td>
                                        <td data-label="Voice Price"><p><?php echo e($op->voice_price); ?></p></td>
                                        <td data-label="MMS Price"><p><?php echo e($op->mms_price); ?></p></td>
                                        <?php if($op->status=='active'): ?>
                                            <td data-label="Status"><p class="label label-success"><?php echo e(language_data('Active')); ?></p></td>
                                        <?php else: ?>
                                            <td data-label="Status"><p class="label label-danger"><?php echo e(language_data('Inactive')); ?></p>
                                            </td>
                                        <?php endif; ?>
                                        <td data-label="Actions">
                                            <a class="btn btn-success btn-xs"
                                               href="<?php echo e(url('sms/manage-operator/'.$op->id)); ?>"><i
                                                        class="fa fa-edit"></i> <?php echo e(language_data('Manage')); ?></a>
                                            <a href="#" class="btn btn-danger btn-xs cdelete" id="<?php echo e($op->id); ?>"><i
                                                        class="fa fa-trash"></i> <?php echo e(language_data('Delete')); ?></a>

                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

    <?php echo Html::script("assets/libs/data-table/datatables.min.js"); ?>

    <?php echo Html::script("assets/js/bootbox.min.js"); ?>


    <script>
      $(document).ready(function () {

        $('.data-table').DataTable({
          language: {
            url: '<?php echo url("assets/libs/data-table/i18n/".get_language_code()->language.".lang"); ?>'
          },
          responsive: true
        });

        /*For Delete operator*/
        $('body').delegate('.cdelete', 'click', function (e) {
          e.preventDefault();
          var id = this.id;
          bootbox.confirm("<?php echo language_data('Are you sure'); ?>?", function (result) {
            if (result) {
              var _url = $('#_url').val();
              window.location.href = _url + '/sms/delete-operator/' + id
            }
          })
        })

      })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>