<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Update Application')); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">
                <div class="col-lg-6">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Update Application')); ?></h3>
                        </div>
                        <div class="panel-body">

                            <h3>Your application version is: <span
                                        class="text-uppercase text-complete"> V <?php echo e(app_config('SoftwareVersion')); ?> </span>
                            </h3>

                            <?php if(app_config('SoftwareVersion') == '2.8'): ?>
                                <h4><span class="text-uppercase text-complete"> Congratulation!!! </span> You are using
                                    latest version</h4>
                                <br>
                                <a href="<?php echo e(url('admin/check-available-update')); ?>" class="btn btn-success">Check for
                                    Updates</a>
                            <?php else: ?>

                                <p class="text-complete">Please update your version with new one. Ultimate SMS Version
                                    2.8 already released</p>

                                <p>To update your application please visit this url: <a href="#">Update Version To
                                        v2.8</a></p>

                                <hr>

                                <form class="" role="form" method="post"
                                      action="<?php echo e(url('admin/post-update-application')); ?>" enctype="multipart/form-data">
                                    <?php echo e(csrf_field()); ?>


                                    <div class="form-group">
                                        <label><?php echo e(language_data('Select File')); ?></label>
                                        <div class="form-group input-group input-group-file">
                                        <span class="input-group-btn">
                                            <span class="btn btn-primary btn-file">
                                                <?php echo e(language_data('Browse')); ?> <input type="file" class="form-control"
                                                                                   name="update_file"
                                                                                   accept="application/zip">
                                            </span>
                                        </span>
                                            <input type="text" class="form-control" readonly="">
                                        </div>
                                    </div>


                                    <button type="submit" class="btn btn-success btn-sm pull-right"><i
                                                class="fa fa-upload"></i> <?php echo e(language_data('Update')); ?> </button>
                                </form>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>