<?php $__env->startSection('content'); ?>

    <section class="wrapper-bottom-sec">
        <div class="p-30">
            <h2 class="page-title"><?php echo e(language_data('Manage Coverage')); ?></h2>
        </div>
        <div class="p-30 p-t-none p-b-none">
            <?php echo $__env->make('notification.notify', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
            <div class="row">
                <div class="col-lg-6">
                    <div class="panel">
                        <div class="panel-heading">
                            <h3 class="panel-title"><?php echo e(language_data('Manage Coverage')); ?></h3>
                        </div>
                        <div class="panel-body">
                            <form class="" role="form" method="post" action="<?php echo e(url('sms/post-manage-coverage')); ?>" enctype="multipart/form-data">
                                <?php echo e(csrf_field()); ?>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Country')); ?></label>
                                    <input type="text" class="form-control" disabled value="<?php echo e($coverage->country_name); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('ISO Code')); ?></label>
                                    <input type="text" class="form-control"  disabled value="<?php echo e($coverage->iso_code); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Country Code')); ?></label>
                                    <input type="text" class="form-control"  disabled value="<?php echo e($coverage->country_code); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Plain')); ?> <?php echo e(language_data('Tariff')); ?></label>
                                    <span class="help"><?php echo e(language_data('Cost for per SMS')); ?></span>
                                    <input type="text" class="form-control" name="plain_tariff" required value="<?php echo e($coverage->plain_tariff); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Voice')); ?> <?php echo e(language_data('Tariff')); ?></label>
                                    <span class="help"><?php echo e(language_data('Cost for per SMS')); ?></span>
                                    <input type="text" class="form-control" name="voice_tariff" required value="<?php echo e($coverage->voice_tariff); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('MMS')); ?> <?php echo e(language_data('Tariff')); ?></label>
                                    <span class="help"><?php echo e(language_data('Cost for per SMS')); ?></span>
                                    <input type="text" class="form-control" name="mms_tariff" required value="<?php echo e($coverage->mms_tariff); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(language_data('Status')); ?></label>
                                    <select class="selectpicker form-control" name="status">
                                        <option value="1" <?php if($coverage->active=='1'): ?> selected <?php endif; ?>><?php echo e(language_data('Live')); ?></option>
                                        <option value="0" <?php if($coverage->active=='0'): ?> selected <?php endif; ?>><?php echo e(language_data('Offline')); ?></option>
                                    </select>
                                </div>

                                <input type="hidden" value="<?php echo e($coverage->id); ?>" name="cmd">
                                <button type="submit" class="btn btn-success btn-sm pull-right"><i class="fa fa-save"></i> <?php echo e(language_data('Update')); ?> </button>

                            </form>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
    <?php echo Html::script("assets/libs/handlebars/handlebars.runtime.min.js"); ?>

    <?php echo Html::script("assets/js/form-elements-page.js"); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>