<?php $__env->startSection('title', 'Ultimate SMS Auto Installer'); ?>


<?php $__env->startSection('vendor-style'); ?>
    <!-- vendor css files -->
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/wizard/bs-stepper.min.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('vendors/css/forms/select/select2.min.css'))); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
    <!-- Page css files -->

    <link rel="stylesheet" href="<?php echo e(asset(mix('css/pages/authentication.css'))); ?>">
    <link rel="stylesheet" href="<?php echo e(asset(mix('css/plugins/forms/bs-wizard.css'))); ?>">

    <style>

        table {
            width: 100%;
            padding: 10px;
            border-radius: 3px;
        }

        table thead th {
            text-align: left;
            padding: 5px 0 5px 0;
        }

        table tbody td {
            padding: 5px 0;
        }

        table tbody td:last-child, table thead th:last-child {
            text-align: right;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <!-- Vertical Wizard -->
    <section class="vertical-wizard flexbox-container">
        <div class="col-xl-12 col-12 d-flex justify-content-center">
            <div class="rounded-0 mb-0">

                <div class="bs-stepper vertical vertical-wizard-example">
                    <div class="bs-stepper-header">

                        <div class="step" data-target="#system_configuration">
                            <button type="button" class="step-trigger">
                                <span class="bs-stepper-box"><i class="feather icon-server"></i></span>
                                <span class="bs-stepper-label">
                                    <span class="bs-stepper-title text-uppercase">System Compatibility</span>
                                    <span class="bs-stepper-subtitle">Check Environments</span>
                                </span>
                            </button>
                        </div>

                        <div class="step" data-target="#check-permissions">
                            <button type="button" class="step-trigger">
                                <span class="bs-stepper-box"><i class="feather icon-shield-off"></i> </span>
                                <span class="bs-stepper-label">
                                    <span class="bs-stepper-title text-uppercase">Permissions</span>
                                    <span class="bs-stepper-subtitle">Set Folder Permissions</span>
                                </span>
                            </button>
                        </div>

                        <div class="step" data-target="#environment-settings">
                            <button type="button" class="step-trigger">
                                <span class="bs-stepper-box"><i class="feather icon-database"></i></span>
                                <span class="bs-stepper-label">
                                    <span class="bs-stepper-title text-uppercase">Environment Settings</span>
                                    <span class="bs-stepper-subtitle">Update your settings</span>
                                </span>
                            </button>
                        </div>

                        <div class="step" data-target="#profile-settings">
                            <button type="button" class="step-trigger">
                                <span class="bs-stepper-box"><i class="feather icon-user"></i> </span>
                                <span class="bs-stepper-label">
                                    <span class="bs-stepper-title text-uppercase">Profile Settings</span>
                                    <span class="bs-stepper-subtitle">Update Your Profile</span>
                                </span>
                            </button>
                        </div>
                    </div>


                    <div class="bs-stepper-content">
                        
                        <div id="system_configuration" class="content">
                            <div class="content-header">
                                <p class="text-primary font-medium-1">You will import only Customer information without balance, Contact list, Blacklist, Keywords data.</p>
                                <p class="text-danger font-medium-1">Rest of the data will be remove like Admin Users, Client Groups, application logo, favicon, Customer Images, etc.</p>
                            </div>
                            <div class="row">

                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th style="width: 500px">Requirements</th>
                                            <th>Result</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        <?php $__currentLoopData = $requirements['requirements']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $requirement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <?php if($type == 'php'): ?>
                                                <tr>
                                                    <td>PHP <?php echo e($phpSupportInfo['minimum']); ?> </td>

                                                    <td>
                                                        <div class="badge badge-<?php echo e($phpSupportInfo['supported'] ? 'success' : 'danger'); ?> text-uppercase mr-1 mb-1"><span><?php echo e($phpSupportInfo['current']); ?></span></div>
                                                    </td>
                                                </tr>
                                            <?php endif; ?>

                                            <?php $__currentLoopData = $requirements['requirements'][$type]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extention => $enabled): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e(ucfirst($extention)); ?> PHP Extension</td>
                                                    <td>
                                                        <?php if($enabled): ?>
                                                            <div class="badge badge-success text-uppercase mr-1 mb-1">
                                                                Enabled
                                                            </div>
                                                        <?php else: ?>

                                                            <div class="badge badge-danger text-uppercase mr-1 mb-1">
                                                                Not Enabled
                                                            </div>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>

                            </div>

                            <div class="d-flex justify-content-between">
                                <button class="btn btn-outline-secondary btn-prev" disabled>
                                    <i class="align-middle mr-sm-25 mr-0 feather icon-arrow-left"></i>
                                    <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                </button>


                                <?php if( ! isset($requirements['errors']) && $phpSupportInfo['supported'] ): ?>
                                    <button class="btn btn-primary btn-next" data-id="is_valid">
                                        <span class="align-middle d-sm-inline-block text-white d-none">
                                            Next
                                        </span>
                                        <i class="feather icon-arrow-right align-middle ml-sm-25 ml-0"></i>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>

                        
                        <div id="check-permissions" class="content">
                            <div class="content-header">
                                <h5 class="mb-0 text-primary text-uppercase">Set Permission 775 following folders</h5>
                            </div>
                            <div class="row">

                                <div class="table-responsive">
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th>Folder</th>
                                            <th>Permission</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        <?php $__currentLoopData = $permissions['permissions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($permission['folder']); ?> </td>

                                                <td>
                                                    <div class="badge badge-<?php echo e($permission['isSet'] ? 'success' : 'danger'); ?> text-uppercase mr-1 mb-1">
                                                        <span><?php echo e($permission['permission']); ?></span>
                                                    </div>
                                                </td>
                                            </tr>

                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>


                            <div class="d-flex justify-content-between">
                                <button class="btn btn-primary btn-prev">
                                    <i class="align-middle mr-sm-25 mr-0 feather icon-arrow-left"></i>
                                    <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                </button>
                                <?php if( ! isset($permissions['errors'])): ?>

                                    <button class="btn btn-primary btn-next" data-id="is_valid">
                                        <span class="align-middle d-sm-inline-block d-none">Next</span>
                                        <i class="align-middle ml-sm-25 ml-0 feather icon-arrow-right"></i>
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>

                        
                        <div id="environment-settings" class="content">
                            <form id="environment_form" style="width: 500px">
                                <?php echo csrf_field(); ?>
                                <div class="content-header">
                                    <h5 class="mb-0">Environment Settings</h5>
                                    <small>Enter Your Database & Application Info.</small>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label class="form-label required" for="app_name">Application Name</label>
                                        <input type="text" id="app_name" class="form-control" name="app_name" required value="<?php echo e(config('app.name')); ?>"/>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-4">
                                        <label class="form-label required" for="app_url">HTTPS Enable</label>
                                        <select name="https_enable" id="https_enable" class="form-control" required>
                                            <option value="true" selected>Yes</option>
                                            <option value="false">No</option>
                                        </select>
                                    </div>


                                    <div class="form-group col-md-8">
                                        <label class="form-label required" for="app_url">Application URL</label>
                                        <input type="text" id="app_url" class="form-control" name="app_url" value="<?php echo e(rtrim(request()->url(), 'update')); ?>" required>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label class="form-label required" for="database-connection">Database Connection</label>
                                        <select name="database_connection" id="database-connection" class="form-control" required>
                                            <option value="mysql" selected>MySQL</option>
                                            <option value="sqlite">Sqlite</option>
                                            <option value="pgsql">PgSQL</option>
                                            <option value="sqlsrv">SQLSrv</option>
                                        </select>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="form-group col-md-8">
                                        <label class="form-label required" for="database_host">Database Host</label>
                                        <input type="text" id="database_host" class="form-control" value="<?php echo e(config('database.connections.mysql.host')); ?>" name="database_host" required/>
                                    </div>
                                    <div class="form-group col-md-4">
                                        <label class="form-label required" for="port">Database Port</label>
                                        <input type="number" id="port" class="form-control" value="3306" name="database_port" required/>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-12">
                                        <label class="form-label required" for="database_name">Database Name</label>
                                        <input type="text" id="database_name" class="form-control" name="database_name" value="<?php echo e(config('database.connections.mysql.database')); ?>" required/>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label required" for="database_user_name">Database Username</label>
                                        <input type="text" id="database_user_name" class="form-control" name="database_username" value="<?php echo e(config('database.connections.mysql.username')); ?>" required/>
                                    </div>

                                    <div class="form-group col-md-6">
                                        <label class="form-label required" for="database_password">Database Password</label>
                                        <input type="password" id="database_password" class="form-control" name="database_password" value="<?php echo e(config('database.connections.mysql.password')); ?>" required/>
                                    </div>

                                </div>

                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-primary btn-prev">
                                        <i class="align-middle mr-sm-25 mr-0 feather icon-arrow-left"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                    </button>


                                    <button type="submit" class="btn btn-primary btn-save">
                                        <span class="align-middle d-sm-inline-block d-none">Save</span>
                                        <i class="align-middle ml-sm-25 ml-0 feather icon-arrow-right"></i>
                                    </button>
                                </div>


                            </form>
                        </div>

                        <div id="profile-settings" class="content">
                            <form id="profile_form">
                                <?php echo csrf_field(); ?>
                                <div class="content-header">
                                    <h5 class="mb-0">Update Your Profile Information</h5>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label required" for="first_name">First Name</label>
                                        <input type="text" id="first_name" class="form-control" required name="first_name"/>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label class="form-label" for="last_name">Last Name</label>
                                        <input type="text" id="last_name" class="form-control" name="last_name"/>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="form-group col-12">
                                        <label class="form-label required" for="email">Email Address</label>
                                        <input type="email" id="email" class="form-control" name="email" required/>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="form-group col-12">
                                        <label class="form-label required" for="password">Password</label>
                                        <input type="password" id="password" class="form-control" required name="password"/>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="form-group col-12">
                                        <label class="form-label required" for="admin_path">Admin Portal Path</label>
                                        <input type="text" id="admin_path" class="form-control" value="admin" required name="admin_path"/>
                                        <p class="small text-primary">It's your admin portal access path url. It only contain one word like admin or admincp</p>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="form-group col-12">
                                        <label class="form-label required" for="timezone">Timezone</label>
                                        <select class="form-control select2" id="timezone" name="timezone">
                                            <?php $__currentLoopData = \App\Library\Tool::allTimeZones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($timezone['zone']); ?>" <?php echo e(config('app.timezone') == $timezone['zone'] ? 'selected': null); ?>> <?php echo e($timezone['text']); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>


                                <div class="row">
                                    <div class="col-12">
                                        <div class="form-group">
                                            <label for="customer" class="required">Create Customer</label>
                                            <select class="form-control" name="customer" id="customer">
                                                <option value="1"><?php echo e(__('locale.labels.active')); ?></option>
                                                <option value="0" selected><?php echo e(__('locale.labels.inactive')); ?> </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="d-flex justify-content-between">
                                    <button class="btn btn-primary btn-prev">
                                        <i class="align-middle mr-sm-25 mr-0 feather icon-arrow-left"></i>
                                        <span class="align-middle d-sm-inline-block d-none">Previous</span>
                                    </button>


                                    <button type="submit" class="btn btn-primary btn-save" id="submitButton">
                                        <span class="align-middle d-sm-inline-block d-none">Save</span>
                                        <i class="align-middle ml-sm-25 ml-0 feather icon-save"></i>
                                    </button>
                                </div>
                            </form>

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- /Vertical Wizard -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
    <!-- vendor files -->
    <script src="<?php echo e(asset(mix('vendors/js/forms/wizard/bs-stepper.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/forms/select/select2.full.min.js'))); ?>"></script>
    <script src="<?php echo e(asset(mix('vendors/js/forms/validation/jquery.validate.min.js'))); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('page-script'); ?>
    <!-- Page js files -->
    <script>
        $(function () {
            'use strict';

            let bsStepper = document.querySelectorAll('.bs-stepper'),
                select = $('.select2'),
                verticalWizard = document.querySelector('.vertical-wizard-example');

            select.select2({
                // the following code is used to disable x-scrollbar when click in select input and
                // take 100% width in responsive also
                dropdownAutoWidth: true,
                width: '100%'
            });


            // Adds crossed class
            if (typeof bsStepper !== undefined && bsStepper !== null) {
                for (let el = 0; el < bsStepper.length; ++el) {
                    bsStepper[el].addEventListener('show.bs-stepper', function (event) {
                        let index = event.detail.indexStep;
                        let numberOfSteps = $(event.target).find('.step').length - 1;
                        let line = $(event.target).find('.step');

                        // The first for loop is for increasing the steps,
                        // the second is for turning them off when going back
                        // and the third with the if statement because the last line
                        // can't seem to turn off when I press the first item. ¯\_(ツ)_/¯

                        for (let i = 0; i < index; i++) {
                            line[i].classList.add('crossed');

                            for (let j = index; j < numberOfSteps; j++) {
                                line[j].classList.remove('crossed');
                            }
                        }
                        if (event.detail.to === 0) {
                            for (let k = index; k < numberOfSteps; k++) {
                                line[k].classList.remove('crossed');
                            }
                            line[0].classList.remove('crossed');
                        }
                    });
                }
            }


            // Vertical Wizard
            // --------------------------------------------------------------------
            if (typeof verticalWizard !== undefined && verticalWizard !== null) {

                let numberedStepper = new Stepper(verticalWizard);

                let verticalStepper = new Stepper(verticalWizard, {
                    linear: false,
                });

                // verticalStepper.to(4);


                $(verticalWizard)
                    .find('.btn-next')
                    .each(function () {
                        $(this).on('click', function (e) {
                            let isValid = $(this).data('id');
                            if (isValid === 'is_valid') {
                                numberedStepper.next();
                            } else {
                                e.preventDefault();
                            }
                        });
                    });

                $(verticalWizard)
                    .find('.btn-next')
                    .each(function () {
                        $(this).on('click', function (e) {
                            let isValid = $(this).data('id');
                            if (isValid === 'is_valid') {
                                numberedStepper.next();
                            } else {
                                e.preventDefault();
                            }
                        });
                    });

                $('#environment_form').on('submit', function (e) {
                    e.preventDefault();

                    $.ajax({
                        type: 'post',
                        url: "<?php echo e(route('Updater::environmentDatabase')); ?>",
                        data: $('#environment_form').serialize(),
                        success: function (data) {

                            if (data.status === 'success') {
                                toastr.success(data.message, 'Hurry!!', {
                                    positionClass: 'toast-top-right',
                                    containerId: 'toast-top-right',
                                    progressBar: true,
                                    closeButton: true,
                                    newestOnTop: true
                                });

                                numberedStepper.next();
                            } else {

                                $.each(data.message, function (key, value) {
                                    toastr.error(value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                        positionClass: 'toast-top-right',
                                        containerId: 'toast-top-right',
                                        progressBar: true,
                                        closeButton: true,
                                        newestOnTop: true
                                    });
                                });
                            }

                        }
                    })
                });

                $('#profile_form').on('submit', function (e) {
                    e.preventDefault();

                    toastr.success('It will take few minutes', 'Hurry!!', {
                        positionClass: 'toast-top-right',
                        containerId: 'toast-top-right',
                        progressBar: true,
                        closeButton: true,
                        newestOnTop: true
                    });

                    $("#submitButton").attr("disabled", true);

                    $.ajax({
                        type: 'post',
                        url: "<?php echo e(route('Updater::database')); ?>",
                        data: $('#profile_form').serialize(),
                        success: function (data) {

                            if (data.status === 'success') {
                                toastr.success(data.message, 'Hurry!!', {
                                    positionClass: 'toast-top-right',
                                    containerId: 'toast-top-right',
                                    progressBar: true,
                                    closeButton: true,
                                    newestOnTop: true
                                });

                                setTimeout(function () {
                                    window.location = data.response_url;
                                }, 2000);
                            } else {

                                $.each(data.message, function (key, value) {
                                    toastr.error(value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                        positionClass: 'toast-top-right',
                                        containerId: 'toast-top-right',
                                        progressBar: true,
                                        closeButton: true,
                                        newestOnTop: true
                                    });
                                });
                            }

                        },

                        error: function (reject) {

                            $(".btn-save").attr("disabled", false);

                            if (reject.status === 422) {
                                let errors = reject.responseJSON.errors;
                                $.each(errors, function (key, value) {
                                    toastr.warning(value[0], "<?php echo e(__('locale.labels.attention')); ?>", {
                                        positionClass: 'toast-top-right',
                                        containerId: 'toast-top-right',
                                        progressBar: true,
                                        closeButton: true,
                                        newestOnTop: true
                                    });
                                });
                            } else {
                                toastr.warning(reject.responseJSON.message, "<?php echo e(__('locale.labels.attention')); ?>", {
                                    positionClass: 'toast-top-right',
                                    containerId: 'toast-top-right',
                                    progressBar: true,
                                    closeButton: true,
                                    newestOnTop: true
                                });
                            }
                        }
                    })
                });


                $(verticalWizard)
                    .find('.btn-next')
                    .on('click', function () {
                        verticalStepper.next();
                    });
                $(verticalWizard)
                    .find('.btn-prev')
                    .on('click', function () {
                        verticalStepper.previous();
                    });
            }

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts/fullLayoutMaster', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smszedek/public_html/web/application/resources/views/Installer/update.blade.php ENDPATH**/ ?>